#!/bin/sh

if [ $# -ne 1 ]; then
    echo "Usage: $0 [src-prefix]"
    exit
fi

SRC=$1

for f in ./*png
do
    prefix=`basename $f .png`
    
    SRC_OBJ=${SRC}.obj
    SRC_MTL=${SRC}.mtl
    SRC_PNG=${SRC}.png

    DEST_OBJ=${prefix}.obj
    DEST_MTL=${prefix}.mtl
    DEST_PNG=${prefix}.png

    /bin/cp -f ${SRC_OBJ} ${DEST_OBJ}
    /bin/cp -f ${SRC_MTL} ${DEST_MTL}

    echo "Prefix: ${prefix}"
    echo "Generate ${DEST_OBJ}"
    echo "Replace ${SRC_MTL} with ${DEST_MTL}"
    /usr/bin/perl -pi -e "s/$SRC_MTL/$DEST_MTL/g" ${DEST_OBJ}

    echo "Generate ${DEST_MTL}"
    echo "Replace ${SRC_PNG} with ${DEST_PNG}"
    /usr/bin/perl -pi -e "s/$SRC_PNG/$DEST_PNG/g" ${DEST_MTL}
    echo "-------------------------------"
    
    rm -f *.bak
done
