--
-- CS527 Electro try-out by Julian Yu-Chung
-- Based on Electro example code viewobj.lua
--
electro_path="/usr/local/electro"
electro_data_path=electro_path.."/examples/data"
local_data_path="/Users/julian/Desktop/527/proj2"

-- Model file path definition --
FLOOR_FILE = local_data_path.."/data/checker.obj"
BOX_FILE   = local_data_path.."/data/box.obj"
WALL_FILE  = local_data_path.."/data/wall.obj"

POD_FILE   = local_data_path.."/data/PodaMan.obj"
PAPER_FILE = local_data_path.."/data/deskAndPaper/paper.obj"

--

HALF_PAPER = 10
ALT = 0.5
half_letter = 0.45
BOID_RANGE = 1.0*1.414*half_letter  -- How close is close
VIEW_RANGE = 5

SF   = 1                          -- Speed Factor
RAT  = 100
vlim = 0.01                       -- velocity magnitude limit
STAY = 'YES'

w1 = 0.1
w2 = 1
w3 = 1
wr = 1

pod_x = -HALF_PAPER/2
pod_y = 1.1
pod_z = -HALF_PAPER+1

-- Letters & some symbols

a_file = local_data_path.."/data/letters/a.obj"
b_file = local_data_path.."/data/letters/b.obj"
c_file = local_data_path.."/data/letters/c.obj"
d_file = local_data_path.."/data/letters/d.obj"
e_file = local_data_path.."/data/letters/e.obj"
f_file = local_data_path.."/data/letters/f.obj"
g_file = local_data_path.."/data/letters/g.obj"
h_file = local_data_path.."/data/letters/h.obj"
i_file = local_data_path.."/data/letters/i.obj"
j_file = local_data_path.."/data/letters/j.obj"
k_file = local_data_path.."/data/letters/k.obj"
l_file = local_data_path.."/data/letters/l.obj"
m_file = local_data_path.."/data/letters/m.obj"
n_file = local_data_path.."/data/letters/n.obj"
o_file = local_data_path.."/data/letters/o.obj"
p_file = local_data_path.."/data/letters/p.obj"
q_file = local_data_path.."/data/letters/q.obj"
r_file = local_data_path.."/data/letters/r.obj"
s_file = local_data_path.."/data/letters/s.obj"
t_file = local_data_path.."/data/letters/t.obj"
u_file = local_data_path.."/data/letters/u.obj"
v_file = local_data_path.."/data/letters/v.obj"
w_file = local_data_path.."/data/letters/w.obj"
x_file = local_data_path.."/data/letters/x.obj"
y_file = local_data_path.."/data/letters/y.obj"
z_file = local_data_path.."/data/letters/z.obj"

comma_file    = local_data_path.."/data/letters/comma.obj"
exclaim_file  = local_data_path.."/data/letters/exclaim.obj"
period_file   = local_data_path.."/data/letters/period.obj"
question_file = local_data_path.."/data/letters/question.obj"
star_file     = local_data_path.."/data/letters/star.obj"
startquote_file = local_data_path.."/data/letters/start_quote.obj"
endquote_file   = local_data_path.."/data/letters/end_quote.obj"

-- Vars
MIN_SIZE_FOR_GEOM = 0.05

numToAlph = { "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k",
              "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
              "w", "x", "y", "z"
            }
letters_path = { a_file, b_file, c_file, d_file, e_file, f_file,
                 g_file, h_file, i_file, j_file, k_file, l_file,
                 m_file, n_file, o_file, p_file, q_file, r_file,
                 s_file, t_file, u_file, v_file, w_file, x_file,
                 y_file, z_file
               }

letters = { } -- access with letters.a, letters.b ... etc
boids   = { } -- starts from 0
-- bins    = { } -- lattice bins

--
tumble = false
scale  = false
test   = false

zoom  = 1
rot_x = 0
rot_y = 0
pan_x = 0
pan_y = 0
pan_z = 0
rot_dy = 0

X0 = 0
Y0 = 0
Z0 = 0
X1 = 0
Y1 = 0
Z1 = 0
XC = 0
YC = 0
ZC = 0

DEFAULT_CAM_X = 0
DEFAULT_CAM_Y = 4
DEFAULT_CAM_Z = 20

-------------------------------------------------------------------------------

function add_rect_object(s, scale, x_loc, y_loc, z_loc, x_rot, y_rot, z_rot,
                         body)
    local obj = add_object(0, s)

    E.set_entity_scale(obj, scale, scale, scale)
    E.set_entity_position(obj, x_loc, y_loc, z_loc)
    E.set_entity_rotation(obj, x_rot, y_rot, z_rot)
    -- FIXME E.set_entity_body_type(obj, body)

    return obj
end

function add_object(i, s)
    local object = E.create_object(s)
    local x0, y0, z0, x1, y1, z1 = E.get_entity_bound(object)
--    local s = 0.5 * (X0 - X1) / (x0 - x1)
    local s = 1.0

    E.parent_entity(object, pivot)
    E.set_entity_scale(object, s, s, s)

    E.set_entity_geom_type(object, E.geom_type_box, (x1-x0), (y1-y0), (z1-z0))
    -- FIXME E.set_entity_flags(object, E.entity_flag_visible_geom, true)

    return object
end

function add_sphere(parent)
    envmap = E.create_image("data/sky_nx.png",
                            "data/sky_px.png",
                            "data/sky_ny.png",
                            "data/sky_py.png",
                            "data/sky_nz.png",
                            "data/sky_pz.png")

    sky = E.create_object("data/sky.obj")

    E.set_brush_image(E.get_mesh(sky, 0), envmap)
    E.set_brush_flags(E.get_mesh(sky, 0), E.brush_flag_unlit,     true)
    E.set_brush_flags(E.get_mesh(sky, 0), E.brush_flag_sky_map_0, true)

    E.parent_entity(sky, parent)

--    E.set_entity_scale(sky, 16, 16, 16)
    E.set_entity_scale(sky, 64, 64, 64)
end

-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--
-- function to load in a given object but not place it within the visible scene.
-- this way we can make multiple copies of this object later on as needed
-------------------------------------------------------------------------------

function load_object(s)
    local object = E.create_object(s)
  
    E.parent_entity(object, pivot)
    return object
end

-------------------------------------------------------------------------------
--
-- function to add a new cube into the scene making a clone of a previously
-- loaded cube object
-- 
-- xloc, yloc, elevation = initial position of the cube
-- ran = whether there will be a slightly random offset to the position
-------------------------------------------------------------------------------

function add_cube(xloc, yloc, elevation, ran)
    local object = E.create_clone(my_cube)
    if ran == 1 then
        deal_with_rectangular_object(object, 0.5,
                    xloc+math.random(), elevation, yloc+math.random(),
                    0, 0, 0,
                    1)
    else
        deal_with_rectangular_object(object, 0.5,
                    xloc, elevation, yloc,
                    0, 0, 0,
                    1)
    end
end

-------------------------------------------------------------------------------
--
-- function to add in an object with a rectangular bounding box and 
-- collision detection into the scene
--
-- s = filename of the object to add
-- sc = scale factor
-- xl, yl, zl = initial position
-- xr, yr, zr = initial orientation
-- body = whether this is a movable body (for collision detection)
-------------------------------------------------------------------------------

function add_rectangular_object(s, sc, xl, yl, zl, xr, yr, zr, body)

    -- create a new object
    local object = E.create_object(s)
    deal_with_rectangular_object(object, sc, xl, yl, zl, xr, yr, zr, body)

    return object
end

-------------------------------------------------------------------------------
--
-- function to set the initial parameters for a rectangular object
--
-- object = the object being dealt with
-- sc = scale factor
-- xl, yl, zl = initial position
-- xr, yr, zr = initial orientation
-- body = whether this is a movable body (for collision detection)
-------------------------------------------------------------------------------

function deal_with_rectangular_object(object, sc, xl, yl, zl, xr, yr, zr, body)

    Xmin = 0
    Ymin = 0
    Zmin = 0
    Xmax = 0
    Ymax = 0
    Zmax = 0

    Xd = 0
    Yd = 0
    Zd = 0

    E.parent_entity(object, scene)
    E.set_entity_scale(object, sc, sc, sc)
    E.set_entity_position(object, xl, yl, zl)
    E.set_entity_rotation(object, xr, yr, zr)
    
    -- lets get the bounding box
        
    Xmin, Ymin, Zmin, Xmax, Ymax, Zmax = E.get_entity_bound(object)
    Xd = (Xmax - Xmin)
    Yd = (Ymax - Ymin)
    Zd = (Zmax - Zmin)
    
    -- lets make sure we have some kind of a box (not just a plane)
    
    if Xd < MIN_SIZE_FOR_GEOM then
        Xd = MIN_SIZE_FOR_GEOM
    end
    
    if Yd < MIN_SIZE_FOR_GEOM then
        Yd = MIN_SIZE_FOR_GEOM
    end
    
    if Zd < MIN_SIZE_FOR_GEOM then
        Zd = MIN_SIZE_FOR_GEOM
    end

    -- lets set the body to true so the object can move
        
    if body == 1 then
        E.set_entity_body_type(object, true)
    else
        E.set_entity_body_type(object, false)
    end
    
    -- lets set the geometry type so we have a bounding box for collisions
        
    E.set_entity_geom_type(object, E.geom_type_box, Xd*sc, Yd*sc, Zd*sc)
    E.set_entity_geom_attr(object, E.geom_attr_callback, 2^32-1)
    
    -- in case we want to check the bounding boxes we can print the values here
    -- print (object, Xmax, Xmin, Ymax, Ymin, Zmax, Zmin)

    return object
end

-------------------------------------------------------------------------------

function do_timer(dt)

-- Mouse interactions
    local joy_x, joy_y = E.get_joystick(0)
    local s = 8

    if joy_x < -0.1 or 0.1 < joy_x then
        E.turn_entity(camera, 0, -joy_x * dt * 90, 0)
    end

    if joy_y < -0.1 or 0.1 < joy_y then
        mov_x, mov_y, mov_z = E.get_entity_z_vector(wand)
        E.move_entity(camera, -mov_x * joy_y * dt * s,
                              -mov_y * joy_y * dt * s,
                              -mov_z * joy_y * dt * s)
    else
        E.turn_entity(camera, 0, -pan_x * dt * 90, 0)

        mov_x, mov_y, mov_z = E.get_entity_y_vector(wand)
        E.move_entity(camera, -mov_x * pan_y * dt * s,
                              -mov_y * pan_y * dt * s,
                              -mov_z * pan_y * dt * s)

        mov_x, mov_y, mov_z = E.get_entity_z_vector(wand)
        E.move_entity(camera, -mov_x * pan_z * dt * s,
                              -mov_y * pan_z * dt * s,
                              -mov_z * pan_z * dt * s)
    end

    if rot_dy < 0 or 0 < rot_dy then
        rot_y = rot_y + rot_dy * dt * 10
        E.set_entity_rotation(pivot, rot_x, rot_y, 0)
    end

-------------------------------------------------------------------------------

    -- Check & output info
    -- print ("Camera pos: ", E.get_entity_position(camera))

    -- do some animations --
    -- animate_x(pod)

    local action

    if STAY == 'YES' then
        action = shake
    elseif STAY == 'NO' then
        action = proc_pos
        table.foreach(boids, standsup)
    end

    -- to flock or not to flock
    -- if math.random(-1,1) > 0 then
    --    w1 = 1 * w1
    -- else
    --    w1 = 1 * w1
    -- end

    table.foreach(boids, action)

    E.set_entity_position(pod, pod_x, pod_y, pod_z)
    -- E.move_entity(pod, pod_x, pod_y, pod_z)

    return true
end

-------------------------------------------------------------------------------

function animate_x(obj)
    local px, py, pz
    px, py, pz = E.get_entity_position(obj)

    px = math.mod(px+1, 10)
    pz = math.mod(pz+1, 10)

    E.set_entity_position(obj, px, py, pz)
end

-------------------------------------------------------------------------------

function proc_pos(i, boid)
    local model = boid.model

    updateDists(i)

    -- Basic 3 rules
    local v1_x, v1_y, v1_z = rule1(boid)
    local v2_x, v2_y, v2_z = rule2(boid)
    local v3_x, v3_y, v3_z = rule3(boid)

    -- Range rule, staying in the range if possible
    local r_x, r_y, r_z = range(boid)

    -- b.velocity = b.velocity + v1 + v2 + v3
    boid.vx = boid.vx + w1*v1_x + w2*v2_x + w3*v3_x + wr*r_x
    boid.vy = boid.vy + w1*v1_y + w2*v2_y + w3*v3_y + wr*r_y
    boid.vz = boid.vz + w1*v1_z + w2*v2_z + w3*v3_z + wr*r_z

    -- Limit velocity
    limit_velocity(boid)

    -- local nx, ny, nz = E.get_entity_z_vector(model)
    -- local angle = vec_angle(-nx, -ny, -nz, boid.vx, boid.vy, boid.vz)
    -- print ("angle:", angle, nx, ny, nz)
    -- E.set_entity_rotation(model, 0, angle, 90);
    -- E.turn_entity(model, 0, 0, angle/10);

    -- b.position = b.position + b.velocity
    local p_x,p_y,p_z = E.get_entity_position(model)

    local next_x = p_x + boid.vx
    local next_y = p_y + boid.vy
    local next_z = p_z + boid.vz

---    if (p_x+boid.vx) > HALF_PAPER then
---        next_x = p_x - boid.vx
---    elseif (p_x+boid.vx) < -HALF_PAPER then
---        next_x = p_x + boid.vx
---    end

--    next_y = p_x + boid.vy
--    if (p_y+boid.vy) > HALF_PAPER then
--        next_x = p_x - boid.vx
--    elseif (p_x+boid.vx) < -HALF_PAPER then
--        next_x = p_x + boid.vx
--    end

---    if (p_z+boid.vz) > HALF_PAPER then
---        next_z = p_z - boid.vz
---    elseif (p_z+boid.vz) < -HALF_PAPER then
---        next_z = p_z + boid.vz
---    end

    E.set_entity_position(model, next_x, next_y, next_z)
end

-------------------------------------------------------------------------------

-- Boids try to fly towards the center of mass of neighboring boids
function rule1(me)
    local rx = 0
    local ry = 0
    local rz = 0

    local count = 0
    local my_x, my_y, my_z = E.get_entity_position(me.model)

    for i in boids
    do
        if boids[i] ~= me then
            local px, py, pz = E.get_entity_position(boids[i].model)

            -- FIXME replace with lattice-bin
            -- local dist = norm(my_x-px, my_y-py, my_z-pz)
            local dist = me.dists[i]
            
            if dist < VIEW_RANGE then
                rx = rx + px
                ry = ry + py 
                rz = rz + pz

                count = count + 1
            end
        end       
    end

    -- local n = table.getn(boids) - 1
    rx = rx / count -- n
    ry = ry / count -- n
    rz = rz / count -- n

    rx = (rx - my_x) / RAT
    ry = (ry - my_y) / RAT
    rz = (rz - my_z) / RAT

    -- return rx / SF, ry / SF, rz / SF
    return rx, ry, rz
end

-- Boids try to keep a small distance away from other objects
function rule2(me)
    local c_x = 0
    local c_y = 0
    local c_z = 0

    local me_x, me_y, me_z = E.get_entity_position(me.model)

    for i in boids
    do
        if boids[i] ~= me then
            local px,py,pz = E.get_entity_position(boids[i].model)
            -- local powsum = (me_x - px)^2 + (me_y - py)^2 + (me_z - pz)^2
            -- math.sqrt(powsum)

            -- local dist = norm( (me_x - px), (me_y - py), (me_z - pz) )
            local dist = me.dists[i]

            if dist < BOID_RANGE then
                c_x = c_x + (me_x - px)
                c_y = c_y + (me_y - py)
                c_z = c_z + (me_z - pz)
            end
        end
    end

    -- return c_x / SF, c_y / SF, c_z / SF
    return c_x, c_y, c_z
end

-- Boids try to match velocity with near boids
function rule3(me)
    local vx = 0
    local vy = 0
    local vz = 0

    local my_x, my_y, my_z = E.get_entity_position(me.model)
    local count = 0

    for i in boids
    do
        if boids[i] ~= me then
            local px, py, pz = E.get_entity_position(boids[i].model)
            -- local dist = norm(my_x-px, my_y-py, my_z-pz)
            local dist = me.dists[i]

            if dist < VIEW_RANGE then
                vx = vx + boids[i].vx - me.vx
                vy = vy + boids[i].vy - me.vy
                vz = vz + boids[i].vz - me.vz
 
                count = count + 1
            end
        end
    end

    -- local n = table.getn(boids) - 1
    local n = count
    vx = vx / (8*n)
    vy = vy / (8*n)
    vz = vz / (8*n)

    -- return vx / SF, vy / SF, vz / SF
    return vx, vy, vz
end

-- Bounding the position
function range(me)
    local v_x = 0
    local v_y = 0
    local v_z = 0
    local b_x, b_y, b_z = E.get_entity_position(me.model)
    
    if b_x < -HALF_PAPER then
        v_x = HALF_PAPER
    elseif b_x > HALF_PAPER then
        v_x = -HALF_PAPER
    end

    if b_y < -ALT then
        v_y = ALT
    elseif b_y > ALT then
        v_y = -ALT
    end

    if b_z < -HALF_PAPER then
        v_z = HALF_PAPER
    elseif b_z > HALF_PAPER then
        v_z = -HALF_PAPER
    end

    -- return v_x / SF, v_y / SF, v_z / SF
    return v_x, v_y, v_z
end

-- Limit boid velocity
function limit_velocity(b)
    local vx = b.vx
    local vy = b.vy
    local vz = b.vz

    local mag = norm(vx, vy, vz)

    if mag > vlim then
        b.vx = (vx / mag) * vlim
        b.vy = (vy / mag) * vlim
        b.vz = (vz / mag) * vlim
    end
end

-------------------------------------------------------------------------------

function shake(i, boid)
    local model = boid.model
    local p_x,p_y,p_z = E.get_entity_position(model)

    local p1_x = p_x
    local p1_y = p_y
    local p1_z = p_z
    
    p1_x = p1_x + math.random(-1, 1)/50
    p1_z = p1_z + math.random(-1, 1)/50

    E.set_entity_position(model, p1_x, p1_y, p1_z)
end

-------------------------------------------------------------------------------

function do_click(b, s)
    if b == 1 then
        tumble = s
    end
    if b == 3 then
        scale  = s
    end

    return true
end

function do_point(dx, dy)
    if tumble then
        rot_x = rot_x + dy
        rot_y = rot_y + dx

        if rot_x >  90.0 then rot_x =  90 end
        if rot_x < -90.0 then rot_x = -90 end

        E.set_entity_rotation(pivot, rot_x, rot_y, 0)

        return true
    end

    if scale then
        zoom = zoom + dy / 500

        E.set_entity_scale(pivot, zoom, zoom, zoom)

        return true
    end

    return false
end

function do_keyboard(k, s)
    local d = 0.125

    if varrier_keyboard then
        if varrier_keyboard(k, s, camera) then
            return true
        end
    end

    if s then
        if k == E.key_return then
            E.set_entity_rotation(pivot,  0.0, 0.0, 0.0)
            E.set_entity_position(camera, 0.0, 0.0, 0.0)
            E.set_entity_rotation(camera, 0.0, 0.0, 0.0)
            rot_x = 0
            rot_y = 0
            pan_x = 0
            pan_y = 0
            pan_z = 0
            return true
        end

	if k == E.key_insert then
            rot_dy = rot_dy + 1
	end

	if k == E.key_delete then
            rot_dy = rot_dy - 1
	end

        if not E.get_modifier(E.key_modifier_control) then
            if k == E.key_up       then pan_z = pan_z + 1 end
            if k == E.key_down     then pan_z = pan_z - 1 end
            if k == E.key_pagedown then pan_y = pan_y + 1 end
            if k == E.key_pageup   then pan_y = pan_y - 1 end
            if k == E.key_right    then pan_x = pan_x + 1 end
            if k == E.key_left     then pan_x = pan_x - 1 end
        end
        
        -- if the user presses the space bar another box will drop
        if k == E.key_space then
            if STAY ~= 'YES' then
                STAY = 'YES'
            else
                STAY = 'NO'
            end
 
            print ("Hello! Space! STAY:",STAY)
        end

        -- modify flocking or not
        if k == E.key_f then
            if w1 == -1 then
                w1 = 1
            else
                w1 = -1
            end
        end

        if k == E.key_w then pod_z = pod_z - 1 end
        if k == E.key_s then pod_z = pod_z + 1 end
        if k == E.key_a then pod_x = pod_x - 1 end
        if k == E.key_d then pod_x = pod_x + 1 end
        
    else
        if not E.get_modifier(E.key_modifier_control) then
            if k == 273 then pan_z = pan_z - 1 end
            if k == 274 then pan_z = pan_z + 1 end
            if k == 281 then pan_y = pan_y - 1 end
            if k == 280 then pan_y = pan_y + 1 end
            if k == 275 then pan_x = pan_x - 1 end
            if k == 276 then pan_x = pan_x + 1 end
        end

        -- if k == E.key_w then pod_z = pod_z + 1 end
        -- if k == E.key_s then pod_z = pod_z - 1 end
        -- if k == E.key_a then pod_x = pod_x + 1 end
        -- if k == E.key_d then pod_x = pod_x - 1 end
 
    end

    return false
end

-------------------------------------------------------------------------------

function do_start()
    -- Init Scene --
    X0, Y0, Z0, X1, Y1, Z1 = E.get_display_bound()

    XC = (X0 + X1) / 2
    YC = (Y0 + Y1) / 2
    ZC = (Z0 + Z1) / 2

    camera = E.create_camera(E.camera_type_perspective)
    light  = E.create_light(E.light_type_directional)
    pivot  = E.create_pivot()
    wand   = E.create_pivot()
    hand   = E.create_pivot()

    E.parent_entity(light, camera)
    E.parent_entity(pivot, light)
    E.parent_entity(wand,  light)
    E.parent_entity(hand,  light)
    
-- Add sphere environment
--    add_sphere(light)

    E.set_entity_position(light,  1.0,  8.0,  8.0)
--    E.set_entity_position(pivot,  XC,   YC,   ZC)
    E.set_entity_position(camera, DEFAULT_CAM_X, DEFAULT_CAM_Y, DEFAULT_CAM_Z)

-------------------------------------------------------------------------------

-- Tracker stuff
--    E.set_entity_tracking(hand, 1, E.tracking_mode_world)
--    E.set_entity_flags   (hand, E.entity_flag_track_pos, true)
--    E.set_entity_flags   (hand, E.entity_flag_track_rot, true)

--    E.set_entity_tracking(wand, 1, E.tracking_mode_local)
--    E.set_entity_flags   (wand, E.entity_flag_track_pos, true)
--    E.set_entity_flags   (wand, E.entity_flag_track_rot, true)

-------------------------------------------------------------------------------
--    add_rectangular_object(WALL_FILE, 0.5,   -5, 5, 0,   0, -90, 0,    0)
--    add_rectangular_object(WALL_FILE, 0.5,   0, 5, -5,   0,   0, 0,    0)
--    add_rect_object(WALL_FILE,   1.0, 0.0, 10.0, -10.0, 0.0, 0.0, 0.0, true)
--    add_rect_object(BOX_FILE,    1.0, -5.0, 1.0, 0.0,  0.0, 0.0, 0.0, true)

    -- Loading stuff
    init_letters()
    init_backdrop()
    load_input_script()

    table.foreach(boids,initDists)

    -- bins = { 
    --       Bin(0), Bin(0), Bin(0), Bin(0),
    --       Bin(0), Bin(0), Bin(0), Bin(0),
    --       Bin(0), Bin(0), Bin(0), Bin(0),
    --       Bin(0), Bin(0), Bin(0), Bin(0)
    --       } 
    -- print("bins size:",table.getn(bins))

    pod = add_rect_object(POD_FILE, 0.5,  
                          pod_x, pod_y, pod_z, 
                          0.0, 0.0, 0.0, true)

    -- table.foreach(E.argument, add_object)
    E.enable_timer(true)
end

-------------------------------------------------------------------------------
function initDists(i, boid)
    local n = table.getn(boids)
    boid.dists = createAEmptyDists(n)
end

function init_letters()
    -- my_cube = load_object(BOX_FILE)
    -- E.set_entity_flags(my_cube, E.entity_flag_hidden, true)
    -- print("Table letters size:",table.getn(letters_path))

    table.foreach(letters_path, load_letter)

    -- Stationary
    my_x = add_rect_object(x_file, 1.0, 
                           0.0, 0.01, 0.0,  
                           0.0, 0.0, 0.0, 
                           true)

    my_b = add_rect_object(b_file, 1.0, 
                           -HALF_PAPER, 0.01, -HALF_PAPER,  
                           0.0, 0.0, 0.0, 
                           true)

    my_o = add_rect_object(o_file, 1.0, 
                           HALF_PAPER, 0.01, -HALF_PAPER,  
                           0.0, 0.0, 0.0, 
                           true)
    my_i = add_rect_object(i_file, 1.0, 
                           HALF_PAPER, 0.01, HALF_PAPER,  
                           0.0, 0.0, 0.0, 
                           true)
    my_d = add_rect_object(d_file, 1.0, 
                           -HALF_PAPER, 0.01, HALF_PAPER,  
                           0.0, 0.0, 0.0, 
                           true)
end

function load_letter(i, s)
    local object = add_object(i, s)
    E.set_entity_flags(object, E.entity_flag_hidden, true)
    letters[numToAlph[i]] = object
    -- letters[i] = object

    -- print ("Loaded but hidden",s)
    -- print ("Alphabet",numToAlph[i],"model is initiated")
    -- return object -- the loop stops once get non-nil return
end

-------------------------------------------------------------------------------

function init_backdrop()
    -- Paper
    add_rect_object(PAPER_FILE,  2.0, 0.0,  0.0, 0.0,  0.0, 0.0, 0.0, true)
    -- Empty desk?
    add_rect_object(FLOOR_FILE, 10.0, 0.0, -0.01, 0.0,  0.0, 0.0, 0.0, true)
end

-------------------------------------------------------------------------------

function load_input_script()
    local file = assert(io.open("input.txt", "r"))
    print ("----- Loading input.txt -----") 

    for line in file:lines() 
    do 
        local toks = strsplit("%s+", line)
        -- print("We have",table.getn(toks),"tokens")
        
        local idx = table.getn(boids)
        -- print("Init boid of letter",toks[1],"in idx",idx,"at position",
        --      toks[2],toks[3],toks[4])

        -- Init/clone a model and add to scene in proper position
        toks.model = E.create_clone(letters[toks[1]])
        toks.vx = 0
        toks.vy = 0
        toks.vz = 0

        E.parent_entity(toks.model, pivot)
        -- TODO auto-layout boids
        E.set_entity_position(toks.model, toks[2], toks[3], toks[4])
        -- E.set_entity_position( toks.model, 
        --                       math.random(-8,8), toks[3], 
        --                       math.random(-8,8) )
        E.set_entity_flags(toks.model, E.entity_flag_hidden, false)

        -- Put the boid to a bin
        local binId = inWhichBin( tonumber(toks[2]), tonumber(toks[4]) )
        -- print("pos:",toks[2],toks[4],"in binId:",binId)

        -- Global boid tracker
        boids[idx] = toks
        boids[idx].bin = binId

        idx = idx + 1
        table.setn(boids, idx)

        -- Local bin boid tracker
        -- local availId = bins[binId].availId
        -- print("binId:",binId,"avail:",availId)
        -- bins[binId].boids[availId] = boids[idx]
        -- bins[binId].availId = table.getn(bins[binId])
 
    end
    print ("-----------------------------")
    file:close()

    print("Now we have",table.getn(boids),"boids")
end

-------------------------------------------------------------------------------

function strsplit(delimiter, text)
    local list = {}
    local pos = 1
    if string.find("", delimiter, 1) then -- this would result in endless loops
        error("delimiter matches empty string!")
    end

    while 1 do
        local first, last = string.find(text, delimiter, pos)
        if first then -- found?
            table.insert(list, string.sub(text, pos, first-1))
            pos = last+1
        else
            table.insert(list, string.sub(text, pos))
            break
        end
    end

    return list
end
-------------------------------------------------------------------------------

function standsup(i, boid)
    local model = boid.model
    -- E.set_entity_position(obj, x_loc, y_loc, z_loc)
    E.set_entity_rotation(model, 90, 0, 0)
end

-- return norm of a 3 component vector
function norm(a, b, c)
    return math.sqrt(a^2 + b^2 + c^2)
end

-- return angle between 2 vectors in degree
function vec_angle(v1x, v1y, v1z, v2x, v2y, v2z)
    local upper = v1x*v2x + v1y*v2y + v1z*v2z
    local lower = norm(v1x, v1y, v1z) * norm(v2x, v2y, v2z)

    return (math.acos(upper/lower) * 180 / math.pi)
end

function Bin(avail)
    return {availId = avail}
end

function inWhichBin(px, pz)
    -- print ("Determine which bin:", px, pz)

    local rowId = 1
    local colId = 1

    for row=1,4
    do
        local min = -HALF_PAPER + (row-1)*HALF_PAPER/2
        local max = min + HALF_PAPER/2

        -- print ("min,max",min,max)
        if (pz >= min) and (pz <= max) then
            rowId = row
        end
    end

    for col=1,4
    do
        local min = -HALF_PAPER + (col-1)*HALF_PAPER/2
        local max = min + HALF_PAPER/2

        if (px >= min) and (px <= max) then
            colId = col
        end
    end

    return (rowId-1) * 4 + colId
end

function createAEmptyDists(n)
    local dists = {}
    for i=1,n
    do
        dists[i] = 0
    end
 
    return dists
end

function updateDists(id)
    local my_x, my_y, my_z = E.get_entity_position(boids[id].model)

    for i in boids
    do
        local px, py, pz = E.get_entity_position(boids[i].model)
        local dist = norm(my_x-px, my_y-py, my_z-pz)
            
        boids[id].dists[i] = dist
    end
end

-------------------------------------------------------------------------------
-- E.set_background(0, 0, 0)

do_start()

